/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*  Fluent Bit
 *  ==========
 *  Copyright (C) 2015-2025 The Fluent Bit Authors
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef FLB_VERSION_H
#define FLB_VERSION_H

#include <fluent-bit/flb_info.h>
#include <fluent-bit/flb_motd.h>
#include <monkey/mk_core.h>

#include <stdio.h>
#include <stdlib.h>

/* Helpers to convert/format version string */
#define STR_HELPER(s)      #s
#define STR(s)             STR_HELPER(s)

/* Fluent Bit Version */
#define FLB_VERSION_MAJOR   25
#define FLB_VERSION_MINOR   11
#define FLB_VERSION_PATCH   3
#define FLB_VERSION         (FLB_VERSION_MAJOR * 10000 \
                             FLB_VERSION_MINOR * 100   \
                             FLB_VERSION_PATCH)
#define FLB_VERSION_STR     "25.11.3"
#define FLB_GIT_HASH        ""

#define CFB_VERSION_STR       "25.11"
#define CFB_VERSION_PATCH_STR "3"

static inline void flb_version()
{
#ifdef FLB_NIGHTLY_BUILD
    printf("NON-PRODUCTION BUILD - Calyptia Fluent Bit v%s, patch_level=%s\n",
           CFB_VERSION_STR, CFB_VERSION_PATCH_STR);
#else
    printf("Calyptia Fluent Bit v%s, patch_level=%s\n",
           CFB_VERSION_STR, CFB_VERSION_PATCH_STR);
#endif
    printf("Git commit: %s\n", FLB_GIT_HASH);

    exit(EXIT_SUCCESS);
}

static inline void flb_version_banner()
{
    const char *copyright_color = ANSI_BOLD ANSI_YELLOW;
    const char *bold_color = ANSI_BOLD;
    const char *reset_color = ANSI_RESET;

    #ifdef FLB_LOG_NO_CONTROL_CHARS
    copyright_color = "";
    bold_color = "";
    reset_color = "";
    #else
    /* Only print colors to a terminal */
    if (!isatty(STDOUT_FILENO)) {
        copyright_color = "";
        bold_color = "";
        reset_color = "";
    }
    #endif // FLB_LOG_NO_CONTROL_CHARS

#ifdef FLB_NIGHTLY_BUILD
    fprintf(stderr,
            "%sCalyptia Fluent Bit v%s, patch_level=%s | NIGHTLY_BUILD=%s"
            " - DO NOT USE IN PRODUCTION!%s\n",
            bold_color,
            CFB_VERSION_STR, CFB_VERSION_PATCH_STR,
            STR(FLB_NIGHTLY_BUILD),
            reset_color);

#else
    fprintf(stderr,
            "%sCalyptia Fluent Bit v%s, patch_level=%s%s\n",
            bold_color,
            CFB_VERSION_STR, CFB_VERSION_PATCH_STR,
            reset_color);

#endif

    fprintf(stderr, "* %sEnterprise Fluent Bit by Calyptia%s\n",
            bold_color, reset_color);
    fprintf(stderr, "* https://calyptia.com\n");
}

#endif
